# 🤖 AI Generator Documentation

## Overview
Sistem AI Generator terintegrasi untuk semua modul admin yang memungkinkan generate otomatis deskripsi menggunakan AI.

## 🎯 Fitur yang Tersedia

### 1. **Biodata AI Generator**
- **Generate Profil Singkat**: Membuat profil singkat berdasarkan nama, keahlian, dan latar belakang
- **Generate Deskripsi Lengkap**: Membuat deskripsi komprehensif untuk CV

### 2. **Education AI Generator**
- Generate deskripsi pendidikan berdasarkan nama sekolah, jurusan, jenjang, dan tahun

### 3. **Work Experience AI Generator**
- Generate deskripsi pengalaman kerja berdasarkan perusahaan, posisi, dan periode kerja

### 4. **Project AI Generator**
- Generate deskripsi proyek berdasarkan nama, teknologi, dan jenis proyek

### 5. **Training AI Generator**
- Generate deskripsi pelatihan berdasarkan nama pelatihan, penyelenggara, dan durasi

### 6. **Organization AI Generator**
- Generate deskripsi organisasi berdasarkan nama organisasi, jabatan, dan bidang

### 7. **Activity AI Generator**
- Generate deskripsi aktivitas harian berdasarkan nama aktivitas dan konteks

## 🔧 Cara Penggunaan

### Untuk Developer

#### 1. Menambahkan AI Generate ke Form Baru
```html
<div class="mb-3 position-relative">
    <label for="deskripsi" class="form-label">Deskripsi</label>
    <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" 
              placeholder="Deskripsi akan diisi otomatis oleh AI atau Anda bisa menulis sendiri..."></textarea>
    
    <!-- AI Generate Button -->
    <button type="button" class="btn btn-outline-primary btn-sm position-absolute ai-generate-btn" 
            style="top: 35px; right: 10px; z-index: 10;" 
            id="generateDescriptionBtn" onclick="generateEducationDescription()">
        <i class="bi bi-magic" id="generateIcon"></i>
        <span id="generateText">Generate AI</span>
    </button>
    
    <!-- AI Status -->
    <div class="ai-status mt-2" id="aiStatus" style="display: none;">
        <div class="alert alert-info alert-sm">
            <i class="bi bi-robot me-1"></i>
            <span id="aiStatusText">Sedang menggenerate deskripsi...</span>
        </div>
    </div>
</div>
```

#### 2. Menambahkan JavaScript Function
```javascript
function generateEducationDescription() {
    aiGenerator.generateEducationDescription();
}
```

#### 3. Menambahkan Route API Baru
```php
$routes->post('generate-new-content', 'AIGeneratorController::generateNewContent');
```

#### 4. Menambahkan Method di AIGeneratorController
```php
public function generateNewContent()
{
    if (!$this->request->isAJAX()) {
        return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
    }

    $data = $this->request->getPost('data');
    
    if (empty($data)) {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Data harus diisi'
        ]);
    }

    $result = $this->aiService->generateNewContent($data);
    return $this->response->setJSON($result);
}
```

#### 5. Menambahkan Method di AITextGeneratorService
```php
public function generateNewContent($data)
{
    $prompt = $this->buildNewPrompt($data);
    return $this->callAPI($prompt);
}

private function buildNewPrompt($data)
{
    return "Buatkan deskripsi untuk: {$data}...";
}
```

## 🎨 Styling CSS

### AI Generate Button
```css
.ai-generate-btn {
    border-radius: 8px;
    font-size: 0.875rem;
    padding: 6px 12px;
    transition: all 0.3s ease;
    background: rgba(255, 255, 255, 0.9);
    backdrop-filter: blur(10px);
    border: 1px solid var(--primary-color);
}

.ai-generate-btn:hover {
    background: var(--primary-gradient);
    color: white;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}
```

### AI Status Messages
```css
.ai-status .alert {
    border-left: 4px solid var(--primary-color);
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
    color: var(--primary-color);
    font-weight: 500;
}
```

## 🔄 API Endpoints

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api/ai/generate-education` | POST | Generate deskripsi pendidikan |
| `/api/ai/generate-work` | POST | Generate deskripsi pekerjaan |
| `/api/ai/generate-project` | POST | Generate deskripsi proyek |
| `/api/ai/generate-training` | POST | Generate deskripsi pelatihan |
| `/api/ai/generate-organization` | POST | Generate deskripsi organisasi |
| `/api/ai/generate-activity` | POST | Generate deskripsi aktivitas |
| `/api/ai/generate-biodata-profile` | POST | Generate profil biodata |
| `/api/ai/generate-biodata-description` | POST | Generate deskripsi lengkap biodata |

## 📝 Request Format

### Standard Request
```javascript
const formData = new FormData();
formData.append('nama_sekolah', 'Universitas ABC');
formData.append('jurusan', 'Ilmu Komputer');
formData.append('jenjang', 'S1');

fetch('/api/ai/generate-education', {
    method: 'POST',
    body: formData,
    headers: {
        'X-Requested-With': 'XMLHttpRequest'
    }
})
```

### Response Format
```json
{
    "success": true,
    "text": "Generated description text..."
}
```

## 🛠️ Konfigurasi AI Service

### API Configuration
```php
// app/Services/AITextGeneratorService.php
private $apiKey = 'your-api-key';
private $baseUrl = 'https://openrouter.ai/api/v1/chat/completions';
private $model = 'nvidia/nemotron-3-nano-30b-a3b:free';
```

### Prompt Templates
Setiap jenis konten memiliki template prompt yang disesuaikan:

- **Education**: Fokus pada pengalaman belajar dan kompetensi
- **Work**: Fokus pada tanggung jawab dan pencapaian
- **Project**: Fokus pada teknologi dan fitur
- **Training**: Fokus pada materi dan learning outcomes
- **Organization**: Fokus pada leadership dan teamwork
- **Activity**: Fokus pada pengalaman dan pembelajaran
- **Biodata**: Fokus pada profil profesional dan value proposition

## 🎯 Best Practices

### 1. **Form Validation**
- Selalu validasi field yang diperlukan sebelum generate
- Berikan feedback yang jelas kepada user

### 2. **Loading States**
- Tampilkan loading indicator saat generate
- Disable button untuk mencegah multiple requests

### 3. **Error Handling**
- Handle network errors dengan graceful
- Berikan pesan error yang informatif

### 4. **User Experience**
- Auto-hide status messages setelah 3-5 detik
- Berikan visual feedback yang jelas
- Gunakan animasi yang smooth

### 5. **Performance**
- Implement timeout untuk API calls
- Cache hasil generate jika memungkinkan
- Optimize prompt untuk response yang cepat

## 🔒 Security Considerations

1. **CSRF Protection**: Semua request menggunakan CSRF token
2. **Input Validation**: Validasi semua input sebelum dikirim ke AI
3. **Rate Limiting**: Implement rate limiting untuk mencegah abuse
4. **API Key Security**: Jangan expose API key di frontend

## 📊 Monitoring & Analytics

### Metrics to Track
- Generate success rate
- Average response time
- Most used generators
- Error frequency
- User satisfaction

### Logging
```php
log_message('info', 'AI Generate: ' . $endpoint . ' - Success: ' . ($result['success'] ? 'Yes' : 'No'));
```

## 🚀 Future Enhancements

1. **Multiple AI Providers**: Support untuk berbagai AI service
2. **Custom Prompts**: Allow user untuk customize prompt
3. **Batch Generation**: Generate multiple content sekaligus
4. **Template Library**: Pre-built templates untuk berbagai use case
5. **AI Suggestions**: Suggest improvements untuk existing content
6. **Multi-language**: Support untuk bahasa lain
7. **Content Optimization**: AI-powered content optimization
8. **Plagiarism Check**: Integrate plagiarism detection
9. **SEO Optimization**: AI-powered SEO suggestions
10. **Voice Input**: Generate dari voice input

## 📞 Support

Untuk pertanyaan atau issue terkait AI Generator:
- Check dokumentasi ini terlebih dahulu
- Review code di `app/Services/AITextGeneratorService.php`
- Check JavaScript di `public/assets/js/ai-generator.js`
- Test API endpoints menggunakan Postman atau tools serupa

---

**Happy Generating! 🤖✨**